﻿using System;
using System.Web;
using System.Web.Http;

using VIRP_WEB.BaseCode;
using VIRP_WEB.Configuration;

namespace VIRP_WEB
{
    public class Global : HttpApplication
    {
        protected void Application_Start(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("VIRP_WEB Started", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);

            if (Application["ApplicationSession"] == null)
                Application["ApplicationSession"] = new ApplicationSession();

            // WebApi Config
            GlobalConfiguration.Configure(WebApiConfig.Register);
        }

        protected void Application_End(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("VIRP_WEB Ending", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);

            Application["ApplicationSession"] = null;
        }

        protected void Application_Error(object sender, EventArgs e)
        {
            Exception ex = Server.GetLastError();
            ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
        }

        //void Application_OnAuthenticateRequest(object sender, EventArgs e)
        //{
        //}

        protected void Session_OnStart()
        {
            //if (HttpContext.Current != null && HttpContext.Current.User != null && HttpContext.Current.User.Identity != null && !string.IsNullOrEmpty(HttpContext.Current.User.Identity.Name))
            //{
            //    ServiceInterfaceManager.USERS_SAVECurrentRegistry(HttpContext.Current.User.Identity.Name, string.Empty);
            //}

            if (Session["UserSession"] == null)
                Session["UserSession"] = new UserSession();
        }

        protected void Session_OnEnd()
        {
            Session["UserSession"] = null;
        }
    }
}
